;******************************************************************  
;That can't be modified by user.
;******************************************************************  
INCLUDE "NPH_RX_MCU.inc"

;------------------------------------------------------------------        
XTAL		EQU	1600		;*10KHz
FIF			EQU	20			;*10KHz

XO_TRIM		EQU	10h
;------------------------------------------------------------------        
DEVICE_NO	EQU	25h

;----5V--------  
BC_FSKDM1	EQU	05h

BC_AGC1		EQU	0Bh
BC_AGC2		EQU	0Ch
BC_AGC3	    EQU	0Dh

BC_OM		EQU	10h

BC_SX1		EQU	12h
BC_SX2		EQU	13h
BC_SX3		EQU	14h
BC_SX4		EQU	15h

BC_XO1		EQU	1Fh

BC_AGC7		EQU	2Bh

BC_TEST3	EQU	32h

BC_I2C1		EQU	40h
;----------------------------------------------------------

if	FSK_OOK==0	;FKS
BC_AGC1_V   EQU 42h
BC_AGC2_V   EQU 27h
SLICER_SEL  EQU 01h        ;8xh=FSK, 01h=OOK	

else            ;OOK
BC_AGC1_V   EQU 41h
BC_AGC2_V   EQU 25h
SLICER_SEL  EQU 00h        ;8xh=FSK, 01h=OOK
	
endif

;----------------------------------------------------------
if	(FREQ < 38000)
	#define FRDIV		0
	#define	RF_BAND		0
	#define	NFREQ		(FREQ-FIF)*(1<<FRDIV)*2

	#define	MMDEXT		1
	
	#define BC_AGC3_V	48h
	#define BC_AGC7_V   28h
	
	if	(FSK_OOK==1)        ;OOK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+OOK_FILTER)
	else                    ;FSK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+FSK_FILTER)
	endif
endif	

if	(FREQ >= 38000) and (FREQ < 47000)
	#define FRDIV		0
	#define	RF_BAND		1
	#define	NFREQ		(FREQ-FIF)*(1<<FRDIV)

	#define	MMDEXT		1
	
	#define BC_AGC3_V	48h
	#define BC_AGC7_V   28h
	
	if	(FSK_OOK==1)        ;OOK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+OOK_FILTER)
	else                    ;FSK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+FSK_FILTER)
	endif
endif	

if	(FREQ >= 47000) and (FREQ <= 51000)
	#define FRDIV		0
	#define	RF_BAND		1
	#define	NFREQ		(FREQ-FIF)*(1<<FRDIV)

	#define	MMDEXT		1
	
	#define BC_AGC3_V	48h
	#define BC_AGC7_V   28h
	
	if	(FSK_OOK==1)        ;OOK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+OOK_FILTER)
	else                    ;FSK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+FSK_FILTER)
	endif
endif	

if(FREQ >= 80000) and (FREQ <= 89000)
	#define FRDIV		0
	#define	RF_BAND		3	
	#define	NFREQ		(FREQ-FIF)*(1<<FRDIV)

	#define	MMDEXT		0
	
	#define BC_AGC3_V	90h
	#define BC_AGC7_V   50h
	
	if	(FSK_OOK==1)        ;OOK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+OOK_FILTER)
	else                    ;FSK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+BW187K)    ;FSK mode BW above 800MHz frequency can only use 187k
	endif
endif

if(FREQ > 89000)
	#define FRDIV		0
	#define	RF_BAND		3	
	#define	NFREQ		(FREQ-FIF)*(1<<FRDIV)
	
	#define	MMDEXT		0
	
	#define BC_AGC3_V	90h
	#define BC_AGC7_V   50h
	
	if	(FSK_OOK==1)        ;OOK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+OOK_FILTER)
	else                    ;FSK
	#define BC_FSKDM1_V ((SLICER_SEL<<7)+BW187K)    ;FSK mode BW above 800MHz frequency can only use 187k
	endif
endif

;----------------------------------------------------------------
#define BC_TEST3_V   82h
#define BC_XO1_V	((FRDIV<<6)+XO_TRIM)	;b[4:0]=XO_TRIM[4:0]

#define	D_N		((NFREQ*8)/(XTAL*10))
#define	D_K1	((NFREQ*8*16)-(D_N*XTAL*10*16))

#define	D_KH	(D_K1/(XTAL*10))
#define	D_KH1	((D_K1*256)-(D_KH*XTAL*10*256))

#define	D_KM	(D_KH1/(XTAL*10))
#define	D_KM1	((D_KH1*256)-(D_KM*XTAL*10*256))

#define	D_KL	(D_KM1/(XTAL*10))

BC_OM_V			EQU 	(RF_BAND << 5)
BC_SX1_V		EQU		((MMDEXT<<7) + D_N)		
BC_SX2_V		EQU		D_KL		
BC_SX3_V		EQU		D_KM		
BC_SX4_V		EQU		(60h +D_KH)

;-----1.2V-------


;------------------------------------------------------------------        
DELAY	MACRO
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1
		JMP		$+1		
		ENDM

;------------------------------------
SCK_LO	MACRO
		CLR		SCK_PORT
		ENDM						
		
SCK_HI	MACRO
		SET		SCK_PORT
		ENDM								
		
;------------------------------------
SDA_IN	MACRO
		SET		SDA_DIR
		JMP		$+1
		ENDM
		
SDA_OUT	MACRO
		CLR		SDA_DIR
		JMP		$+1
		ENDM
		
SDA_LO	MACRO
		CLR		SDA_PORT
;		CLR		SDA_DIR
		ENDM						
		
SDA_HI	MACRO
;		SET		SDA_DIR
		SET		SDA_PORT
;		CLR		SDA_DIR
		ENDM								

SNZ_SDA	MACRO
		SNZ		SDA_PORT
		ENDM

SZ_SDA	MACRO
		SZ		SDA_PORT
		ENDM

;------------------------------------
I2C_STR	MACRO
		SDA_OUT
		SCK_HI
		SDA_HI
		DELAY
		SDA_LO
		ENDM
		
I2C_STP MACRO
		SDA_OUT
		SDA_LO
		DELAY
		SCK_HI
		DELAY
		SDA_HI
		DELAY
		ENDM
		

;------------------------------------------------------------------        
BC2302_DS	.SECTION	'data'
mBuf		DB	12	DUP(?)
mTemp		DB	2	DUP(?)

BC2302_CS    .SECTION  PAGE	'code'
;--------------------------------------------------------
;--------------------------------------------------------
public	_NPH_RX_Init
_NPH_RX_Init		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF				
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	sbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]			
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			MOV		A,01h
			MOV		mBuf[1],A
			CALL		Write_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		sbi_Lp
			RET			 
_NPH_RX_Init		ENDP

;--------------------------------------------------------
;--------------------------------------------------------
public		_Read_NPH_RX_Reg	
_Read_NPH_RX_Reg		PROC
			MOV		A,LOW PrmTab
			MOV		TBLP,A
	IFDEF	TBHP
			MOV		A,HIGH PrmTab
			MOV		TBHP,A
	ENDIF				
					
			MOV		A,(PrmTabEnd-PrmTab)/2
			MOV		mBuf[3],A
	Rbi_Lp:			
			TABRDC	mBuf[0]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			TABRDC	mBuf[2]
			INC		TBLP
	IFDEF	TBHP
			SZ			Z
			INC		TBHP
	ENDIF
			MOV		A,01h
			MOV		mBuf[1],A
			CALL	Read_I2C_Multi_Byte
			SDZ		mBuf[3]
			JMP		Rbi_Lp
			RET

_Read_NPH_RX_Reg		ENDP
			
;------------------------------------
PrmTab:	
	DW  BC_TEST3
	DW  BC_TEST3_V 
	
	DW	BC_FSKDM1 ;Demodulator operation clock divider selection(187/93/46);Selection of slicer type(ook/fsk)
	DW	BC_FSKDM1_V
	
	DW  BC_AGC1
	DW  BC_AGC1_V
	
	DW  BC_AGC2
	DW  BC_AGC2_V
	
	DW  BC_AGC3
	DW  BC_AGC3_V
	
	DW  BC_AGC7
	DW  BC_AGC7_V
	
	DW	BC_OM         ;Operation Mode Control 
	DW	BC_OM_V	      ;(RF_BAND << 5)  FREQ determine RF_BAND(3/4/8/9)
		
	DW	BC_SX1		  ;FREQ set
	DW	BC_SX1_V	
					
	DW	BC_SX2		
	DW	BC_SX2_V	
				
	DW	BC_SX3		
	DW	BC_SX3_V	
					
	DW	BC_SX4		
	DW	BC_SX4_V
	
	DW	BC_XO1		
	DW	BC_XO1_V
		
PrmTabEnd:								

;--------------------------------------------------------
public _Entry_I2C_mode
_Entry_I2C_mode	PROC
			SDA_LO
			SDA_OUT
			DELAY
			SCK_LO
			CALL	_Delay_1ms
			CALL	_Delay_1ms
			RET
_Entry_I2C_mode	ENDP

;--------------------------------------------------------
public _Exit_I2C_mode
_Exit_I2C_mode	PROC
			MOV		A,BC_I2C1
			MOV		mBuf[0],A
			MOV		A,01h
			MOV		mBuf[2],A			
			MOV		A,01h
			MOV		mBuf[1],A
			JMP		Write_I2C_Multi_Byte
_Exit_I2C_mode	ENDP

;--------------------------------------------------------
public _Set_DEM_mode
_Set_DEM_mode	PROC
			MOV		mBuf[0],A
			MOV		A,01h
			MOV		mBuf[2],A			
			MOV		A,01h
			MOV		mBuf[1],A
			JMP		Write_I2C_Multi_Byte
_Set_DEM_mode	ENDP

;********************************************************
;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length, mBuff[9:2]=data
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
public Write_I2C_Multi_Byte
Write_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail

			MOV		A,mBuf[1]
			MOV		mTemp[1],A
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A
	wimb_Lp:	
			MOV		A,IAR0
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		wimb_Fail
			INC		MP0					
			SDZ		mTemp[1]
			JMP		wimb_Lp
	wimb_Fail:
			CALL	I2C_Stop
			RET
Write_I2C_Multi_Byte	ENDP			

;--------------------------------------------------------
; input    : mBuff[0]=addr. ,mBuff[1]=length
; output   : mBuf[9:2]
; template : MP0, mTemp[0], mTemp[1]
;--------------------------------------------------------
Read_I2C_Multi_Byte	PROC
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,mBuf[0]
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			CALL	I2C_Start
			
			MOV		A,(DEVICE_NO<<1)+1
			CALL	I2C_SendByte
			CALL	I2C_GetAck
			SZ		C
			JMP		rimb_Fail
			
			MOV		A,OFFSET mBuf[2]
			MOV		MP0,A									
			MOV		A,mBuf[1]
			MOV		mTemp[1],A
	rimb_Lp:	
			CALL	I2C_GetByte
			MOV		IAR0,A
			INC		MP0
			
			SET		C
			SDZA	mTemp[1]			
			CLR		C
			CALL	I2C_SendAck
			SDZ		mTemp[1]	
			JMP		rimb_Lp
			
	rimb_Fail:			
			CALL	I2C_Stop
			RET
Read_I2C_Multi_Byte	ENDP			

;********************************************************
;--------------------------------------------------------
public	_I2C_Init
_I2C_Init		PROC
			SDA_HI		
			SCK_HI		
			CLR		SCK_DIR
			CLR		SDA_DIR
			
			MOV		A,32
			MOV		mTemp,A
		LOOP:
			CALL		_Delay_1ms
			SDZ		mTemp
			
			JMP		LOOP
			ret
_I2C_Init		ENDP

public	_RX_Off
_RX_Off		PROC
			SCK_HI
;			SDA_OUT
			RET
_RX_Off		ENDP

public	_RX_On
_RX_On		PROC
			SDA_IN
			SCK_LO
			RET
_RX_On		ENDP

;--------------------------------------------------------
public	I2C_Start
I2C_Start	PROC
			I2C_STR
			RET
I2C_Start	ENDP
				
;--------------------------------------------------------
;--------------------------------------------------------
public	I2C_Stop
I2C_Stop	PROC
			I2C_STP
			RET
I2C_Stop	ENDP
				
;--------------------------------------------------------
; Input : ACC=Data
; Template : mTemp[0]
;--------------------------------------------------------
public	I2C_SendByte
I2C_SendByte	PROC
			SDA_OUT
			MOV		mTemp,A
			MOV		A,08h
	isb_Lp:		
			SCK_LO
			RLC		mTemp
			SZ		C
			JMP		$1			
	$0:
			SDA_LO
			JMP		$9						
	$1:		
			SDA_HI	
	$9:	
			JMP		$+1
			SCK_HI
			DELAY
			SDZ		ACC
			JMP		isb_Lp
			SCK_LO
			SDA_IN			
			RET
I2C_SendByte	ENDP

;--------------------------------------------------------
; Template : mTemp[0]
; Output : ACC
;--------------------------------------------------------
public I2C_GetByte
I2C_GetByte	PROC
			SDA_IN
			MOV		A,08h
	igb_Lp:		
			SCK_LO
			DELAY
			
			SCK_HI
			CLR		C
			SZ_SDA
			SET		C			
			RLC		mTemp
			
			SDZ		ACC
			JMP		igb_Lp
			
			SCK_LO
			MOV		A,mTemp			
			RET
I2C_GetByte	ENDP

;--------------------------------------------------------
; Input : C
;--------------------------------------------------------
I2C_SendAck	PROC
			SDA_OUT
			SZ		C
			JMP		$1
	$0:
			SDA_LO
			JMP		$9			
	$1:				
			SDA_HI	
	$9:
			SCK_HI
			DELAY
			SCK_LO
			RET
I2C_SendAck	ENDP

;--------------------------------------------------------
; Output : C
;--------------------------------------------------------
I2C_GetAck	PROC
			SDA_IN
;			DELAY
			SCK_HI
			DELAY
			CLR		C
			SZ_SDA
			SET		C		
			SCK_LO
			RET
I2C_GetAck	ENDP

;--------------------------------------------------------
;void	InitRxTM(void);
;--------------------------------------------------------
public	_InitRxTM
_InitRxTM	proc
			InitRxTM
			RET
_InitRxTM	endp

;--------------------------------------------------------
;void	RFTimerOn(void);
;--------------------------------------------------------
public	_RFTimerOn
_RFTimerOn	proc
			RFTimerOn
			RET
_RFTimerOn	endp

;--------------------------------------------------------
;void	RFTimerOff(void);
;--------------------------------------------------------
public	_RFTimerOff
_RFTimerOff	proc
			RFTimerOff
			RET
_RFTimerOff	endp

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_10us
Delay_10us	PROC
			MOV		A,4
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_10us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	Delay_100us
Delay_100us	PROC
			MOV		A,49
			NOP
			SDZ		ACC
			JMP		$-2
			RET
Delay_100us	ENDP

;--------------------------------------------------------
;fsys=8Mhz
;--------------------------------------------------------
public	_Delay_1ms
_Delay_1ms	PROC
			MOV		A,167
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			MOV		A,166
			SDZ		ACC
			JMP		$-1

			MOV		A,166
			SDZ		ACC
			JMP		$-1
			
			RET
_Delay_1ms	ENDP
		